package cn.smarthse.rho.modules.sys.provider.e;

import cn.smarthse.rho.modules.sys.model.d.param.AddDeviceCheckByMaterialsParam;
import cn.smarthse.rho.modules.sys.model.e.vo.DeviceLocationStatisticVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceDetailVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomListVo;
import cn.smarthse.rho.modules.sys.model.e.vo.LocationDeviceStatisticVo;

import java.util.List;

/**
 * 设备CommonService
 *
 * @author chuhy
 * @date 2024/4/28 14:37
 */
public interface IEDeviceCommonProvider {

    /**
     * 获取设备（射线）详情
     *
     * @param did 设备id
     * @return EDeviceRayDetailVo
     */
    EDeviceDetailVo getEDeviceDetailVo(Long did);

    /**
     * 统计场所关联的正常使用设备数
     *
     * @param locationIds 场所ids
     * @param cid         医院id
     * @return EDeviceRayDetailVo
     */
    List<LocationDeviceStatisticVo> getLocationDevicesNumByLocationIds(List<Long> locationIds, Long cid);

    /**
     * 设备关联的场所
     *
     * @param deviceIds 设备ids
     * @param cid       医院id
     * @return EDeviceRayDetailVo
     */
    DeviceLocationStatisticVo getDevicesLocationByDeviceIds(Long deviceId, Integer deviceType, Long cid);

    /**
     * 获取关联的机房列表
     * @param deviceId 设备id
     * @return List<EMachineRoomListVo>
     */
    List<EMachineRoomListVo> listRelationMachineRoomByDId(Long id);


    /**
     * 监管端 - 佐证材料验收后，将数据添加到性能检测数据中
     * @author chuhy
     * @date 2025/12/9 8:55
     */
    void saveDeviceCheckDataByMaterials(AddDeviceCheckByMaterialsParam  param);
}
