package cn.smarthse.rho.modules.sys.provider.company;

import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAdminEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.ChangeLicenseCompanyParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseCompanyListVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.CompanyImportDto;
import cn.smarthse.rho.modules.sys.model.sys.param.*;
import cn.smarthse.rho.modules.sys.model.sys.vo.BCompanyChooseVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyOneVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * 单位信息接口
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/3/28 9:54
 */
public interface ICompanyProvider {

    /**
     * 某个区域是否有直属企业（level > 2）
     */
    Boolean isHasBelongTypeComByAreaId(Long areaId);

    /**
     * 查询单位信息
     *
     * @param cid 单位id
     * @return {@link BCompanyVo}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/4 16:50
     */
    BCompanyVo getCompany(Long cid);

    BCompanyVo getBaseInfoForLicense(Long cid);

    LayuiGridData<ChangeLicenseCompanyListVo> getListForChangeLicense(ChangeLicenseCompanyParam param);

    /**
     * 获取得列表（浙里办报名选择单位用）
     *
     * @param param
     * @return PageInfo<BCompanyVo>
     * @Author ChenLiang
     * @Date 16:11 2024/8/9
     */
    PageInfo<BCompanyVo> getListForZLB(SysCompanyListParam param);

    /**
     * 获取监督单位
     *
     * @param cid
     * @return String
     * @Author ChenLiang
     * @Date 8:37 2024/9/9
     */
    Map<String, Object> getSuperviseUnit(Long cid);

    /**
     * 监管端：医院弹窗选择
     *
     * @param param
     * @return LayuiGridData<BCompanyChooseVo>
     * @Author ChenLiang
     * @Date 14:28 2024/7/22
     */
    LayuiGridData<BCompanyChooseVo> getChooseList(BCompanyChooseListParam param);

    /**
     * 监管端：系统模块-院区管理：列表
     *
     * @param param
     * @return {@link LayuiGridData<SysCompanyListVo>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/23 16:34
     */
    LayuiGridData<SysCompanyListVo> getSysCompanyListData(SysCompanyListParam param);

    /**
     * 监管端：系统模块-院区管理：详情
     *
     * @param cid 单位id
     * @return {@link SysCompanyOneVo}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/24 13:35
     */
    SysCompanyOneVo getSysCompany(Long cid);

    /**
     * 监管端：系统模块-院区管理：编辑
     *
     * @param param
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/4 10:07
     */
    Boolean updateSysCompany(SysCompanyEditParam param);

    /**
     * 监管端：系统模块-院区管理：院区状态
     */
    Boolean updateSysCompanyStatue(SysCompanyStatueEditParam param);

    /**
     * 监管端：系统模块-院区管理：是否为主院
     */
    Boolean updateSysCompanyIsMain(SysCompanyStatueEditParam param);

    /**
     * 监管端：系统模块-院区管理：营业状态
     */
    Boolean updateSysCompanyBusinessStatue(SysCompanyUserBusinessStatueEditParam param);
    Boolean updateSysCompanyLicenceStatue(SysCompanyUserLicenceStatueEditParam param);

    void importCompany(List<CompanyImportDto> paramList);

    void addInfo(BCompanyAdminEditParam param);

    void editBaseInfo(BCompanyEditParam param);
}
