package cn.smarthse.rho.modules.sys.provider.company;

import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAddressEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.OrgCompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;

import java.util.List;

/**
 * @Author: czq
 * @Creat: 2025-08-27 15:03
 */
public interface IBCompanyAddressProvider {

    /*
    * 根据cid获取地址列表
     */
    List<BCompanyAddress> getAddressListByCid(Long cid);
    List<CompanyAddressVo> getAddressVoList(Long cid);

    List<CompanyAddressVo> getAddressVoListForCompanyBaseInfoPage(Long cid);

    /*
    * 批量添加/修改 医院地址
     */
    boolean saveBatch(List<BCompanyAddressEditParam> entityList);

    /*
    * 批量删除医院地址
     */
    boolean removeBatchByIds(List<Long> idList);

    CompanyAddressVo getOneAddressVo(Long subCid);

    /*
     * 修改医院地址
     */
    void editCompanyAddressById(BCompanyAddressEditParam param);

    /*
     * 新增院区执业地址
     */
    void addCompanyAddress(BCompanyAddressEditParam param);

    /*
     * 根据id删除医院地址
     */
    void deleteCompanyAddressById(Long id);

    /**
     * 根据名称获取
     */
    BCompanyAddress getAddressByName(String name, Long cid);

    BCompanyAddress getAddressById(Long id);

    List<OrgCompanyAddressVo> getOrgCompanyAddressVo(Long cid);

    BCompanyAddress getMainAddress(Long cid);
}
