package cn.smarthse.rho.modules.sys.provider.company;

import cn.smarthse.rho.modules.sys.model.b.param.BCompanyInfoParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCertVo;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData41;

import java.util.List;

/**
 * <p>
 * 医院：放射诊疗许可证 服务类
 * </p>
 *
 * @author chenliang
 * @since 2024-03-29
 */
public interface IBCertProvider {

    List <BCertVo> getByCid(Long cid);

    /**
     * 基础信息管理-证书基础信息
     *
     * @param param
     * @return
     */
    BCertVo getBaseInfoForCompany(BCompanyInfoParam param);

    BCertVo getBaseInfoForChangeLicense(Long cid);

    /**
     * 方法描述:  放射诊疗许可证信息
     *
     * @param cid 企业id
     * @return HomeData41
     * @author wuxq
     * @since 2024/6/17
     */
    HomeData41 getHomeData41ByCid(Long cid);
}
