package cn.smarthse.rho.modules.sys.provider.c;


import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.model.b.param.check.ViewNumParam;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.c.param.*;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckNameParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckStaffRelationParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.RayManagerEditMainParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.StaffPostEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocationExportParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertStaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChangeLogVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffSelectInfo;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationExportVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDtoV2;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;

import java.time.LocalDateTime;
import java.util.List;


public interface IStaffProvider {

    /**
     * 人员信息修改日志
     * @Author ChenLiang
     * @Date 13:38 2024/8/26
     * @param param
     * @return LayuiGridData<StaffChangeLogVo>
     */
    LayuiGridData<StaffChangeLogVo> getStaffChangeLog(StaffChangeLogParam param);
    LayuiGridData<CertStaffChooseListVo> getCertStaffChooseList(CertStaffChooseListParam param);


    /**
     * 人员信息查看范围（公司）
     * @Author ChenLiang
     * @Date 9:20 2024/10/22
     * @param param
     * @return CStaffInfoRangeVo
     */
    CStaffInfoRangeVo getStaffInfoRangeForCompany(CStaffInfoRangeParam param);

    /**
     * 人员信息查看范围（监管）
     * @Author ChenLiang
     * @Date 9:20 2024/10/22
     * @param param
     * @return CStaffInfoRangeVo
     */
    CStaffInfoRangeVo getStaffInfoRangeForAdmin(CStaffInfoRangeParam param);


    /**
     * 用户选择专用，关键信息加上脱敏
     * @param idCard
     * @return
     */
    StaffSelectInfo getSelectInfoForAdding(StaffSelectInfoParam param);

    void addManager(CStaffBaseInfoEditParam param);

    void addStaffFullInfo(CStaffBaseInfoEditParam param);

    void editStaffFullInfo(CStaffBaseInfoEditParam param);

    void addStaffInfo(CStaffEditParam param);

    void editStaffInfo(CStaffEditParam param);

    Integer checkName(CheckNameParam param);

    String companyImportStaff(List<StaffImportDtoV2> importInfoList, Long afterSwitchCid);

    List<SysAreaVo> getAreaList(Long staffBaseInfoId);

    Integer getCompanyViewNumBySbId(ViewNumParam param);

    void deleteStaff(CStaffDeleteParam param);

    boolean hasRelatedData(CheckStaffRelationParam param);

    boolean canEditStaffInfoByCompany(Long sbId, Long cid);

    void editMainManager(RayManagerEditMainParam param);

    void editRayPostType(StaffPostEditParam param);

    List<StaffRelocationExportVo> getListForRelationExport(StaffRelocationExportParam param);

    void editDtPostForRiskSdFileModel(Long sbId, Long cid, LocalDateTime dtTime);

    void editTpPostForRiskSdFileModel(Long sbId, Long cid, LocalDateTime tpTime, LocalDateTime preOnTime);
}
