package cn.smarthse.rho.modules.sys.provider.c;

import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheck;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.HealthCheckParam;
import cn.smarthse.rho.modules.sys.model.c.param.hc.HealthInitParam;

/**
 * <p>
 * 医院：职业健康体检 服务类
 * </p>
 *
 * @author wuxq
 * @since 2024-04-10
 */
public interface ICHealthCheckProvider {


    /**
     * 方法描述:  获取体检数据列表
     *
     * @param param 查询参数
     * @return LayuiGridData<CHealthCheck>
     * @author wuxq
     * @since 2024/4/16
     */
    LayuiGridData<CHealthCheck> getList(CHealthCheckQueryParam param);

    /**
     * 方法描述:
     *
     * @param baseId 主表id
     * @return CHealthCheck
     * @author wuxq
     * @since 2024/4/16
     */
    CHealthCheck getDetailById(Long baseId);

    void initInfo(HealthInitParam param);

    CHealthCheck getOneInfo(HealthCheckParam healthCheckParam);

    void insertBaseId(HealthInitParam param);

}
