package cn.smarthse.rho.modules.sys.provider.c;

import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.hc.HCRiskSdFileModelAddParam;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData33;
import cn.smarthse.rho.modules.sys.model.r.vo.HcFactorVo;

import java.util.List;
import java.util.Map;


/**
 * <p>
 * 医院：职业健康体检详情 服务类
 * </p>
 *
 * @author wuxq
 * @since 2024-04-10
 */
public interface ICHealthCheckDataProvider {


    /**
     * 方法描述:  体检结果详情列表
     *
     * @param param 查询参数
     * @return LayuiGridData<CHealthCheckData>
     * @author wuxq
     * @since 2024/4/16
     */
    LayuiGridData<CHealthCheckData> getResultList(CHealthCheckQueryParam param);

    /**
     * 人员工作档案：体检记录列表
     *
     * @param param
     * @return LayuiGridData<CHealthCheckData>
     * @Author ChenLiang
     * @Date 15:22 2024/6/17
     */
    LayuiGridData<CHealthCheckData> getListForArchive(CHealthCheckQueryParam param);

    /**
     * 方法描述:  可视化-放射工作人员信息-体检统计
     *
     * @param cid 医院id
     * @return HomeData33
     * @author wuxq
     * @since 2024/6/12
     */
    HomeData33 getHomeData33(Long cid);

    /**
     * 获取最近一条数据
     *
     * @param staffBaseInfoId
     * @return CHealthCheckData
     * @Author ChenLiang
     * @Date 10:29 2024/8/23
     */
    CHealthCheckData getLastData(Long staffBaseInfoId);

    void saveOrUpdate(CHealthCheckData data);

    List<HcFactorVo> getViewHcFactorList(List<Long> hcIdList);
    Map<Long, HcFactorVo> getViewHcFactorMap(List<Long> hcIdList);

    void addForOtherProvinces(HCRiskSdFileModelAddParam param);
}
