package cn.smarthse.rho.modules.sys.provider.c;

import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CDoseBigStatisticsVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CDoseDataVo;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData34;
import com.github.pagehelper.PageInfo;

public interface ICDoseDataProvider {

    /**
     * 人员档案：个人剂量列表
     *
     * @param param
     * @return PageInfo<CDoseDataVo>
     * @Author ChenLiang
     * @Date 15:53 2024/6/17
     */
    PageInfo<CDoseDataVo> getDoseListForArchive(CDoseQueryParam param);

    /**
     * 方法描述:  个人剂量监测详情列表
     *
     * @param param 参数
     * @return PageInfo<CDoseData>
     * @author wuxq
     * @since 2024/8/7
     */
    PageInfo<CDoseData> getDoseDataList(CDoseQueryParam param);

    /**
     * 方法描述:  过量照射调查列表
     *
     * @param param 参数
     * @return PageInfo<CDoseData>
     * @author wuxq
     * @since 2024/8/7
     */
    PageInfo<CDoseData> getOverDoseDataList(CDoseQueryParam param);

    /**
     * 方法描述:  首页放射工作人员信息-个人剂量监测
     *
     * @param cid 医院id
     * @return HomeData34
     * @author wuxq
     * @since 2024/8/7
     */
    HomeData34 getHomeData34(Long cid);

    /**
     * 方法描述: 过量照射调查列表右侧统计
     *
     * @param cid 医院id
     * @return BigDoseStatisticsVo
     * @author wuxq
     * @since 2024/8/7
     */
    CDoseBigStatisticsVo getBigDoseStatisticsData(Long cid);

    /**
     * 回去最近一条数据
     *
     * @param staffBaseInfoId
     * @return CDoseData
     * @Author ChenLiang
     * @Date 10:39 2024/8/23
     */
    CDoseData getLastData(Long staffBaseInfoId);

    Boolean updateById(CDoseData param);
}
