package cn.smarthse.rho.modules.sys.model.wanda.sync.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class WandaZwyDeviceVo {
    
    
    // 设备id (外部数据库数据库id)
    private String zwyDeviceId;
    
    // 设备id (放射卫生在线数据库id, 设备来源是放射卫生在线时, 必填)
    private String rhoDeviceId;
    
    // 放射诊疗机构id (外部数据库)
    private String zwyHospitalId;
    
    // 放射诊疗机构id (放射卫生在线)
    private String rhoHospitalId;

    // cid(由zwy_hospital_id字段连b_company查出)
    private Long cid;
    
    // (装置/核素)名称
    private String name;
    
    // (装置/核素)编号
    private String factoryNo;
    
    // (装置/核素)生产厂家
    private String factory;
    
    // 状态 (1-正常；2-暂停使用；3-退役/报废)
    private String status;
    
    // 类型 (1-射线装置；2-非密封放射性核素；3-密封放射性核素；4-含密封源装置)
    private String type;
    
    // (装置)设备移动类型 (1-固定设备；2-移动设备；3-车载设备)
    private String mobilityType;
    
    // (装置)是否为床边机 (0-否；1-是) (mobility_type为2时才有值)
    private String isBedside;
    
    // (装置)放射检查类型 (RayCheckTypeEnum)
    private String checkType;
    
    // (装置)主要参数
    private String parameters;
    
    // (装置)放射诊疗类别 (英文逗号分隔)(DiagnosisTypeEnum)
    private String diagnosisType;
    
    // (装置)型号
    private String model;
    
    // (核素)用途
    private String useTo;
    
    // (核素)最大等效日操作量 (底数，保留两位小数)
    private String dailyData1;
    
    // (核素)最大等效日操作量 (指数)
    private String dailyData2;
    
    // (核素)出厂活度 (底数，保留两位小数)
    private String factoryActivityData1;
    
    // (核素)出厂活度 (指数)
    private String factoryActivityData2;
    
    // (核素)活度测量日期 (yyyy-MM-dd)
    private String measurementDate;
    
    // (核素)出厂日期 (yyyy-MM-dd)
    private String productionDate;
    
    // (核素)国家编码
    private String nuclideUniqueCode;
    
    // 数据来源 (1-放射卫生在线，2-外部数据库)
    private String dataSource;
    
    // 操作类型；1-新增；2-更新；3-删除
    private String optType;
    
    // 更新或删除的数据id，更新删除时必填
    private String oldSourceId;
    
    // 更新或删除原因，更新删除时必填
    private String optReason;
    
    // 万达仓数据创建时间
    private LocalDateTime loadTime;
}


