package cn.smarthse.rho.modules.sys.model.wanda.sync.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓：放射卫生-场所检测数据子表
 *
 * @author wuxq
 * @since 2024/12/11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WandaFswsPlaceCheckDataVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long   id;
    private String sourceId;                // 唯一标识（外部数据库原始数据id）
    private String checkId;                 // 放射诊疗工作场所检测主表id
    private String zwyHospitalId;           // 放射诊疗机构id（外部数据库）
    private String rhoHospitalId;           // 放射诊疗机构id（放射卫生在线）
    private String hospitalName;            // 所在放射诊疗机构名称
    private String hospitalCreditCode;      // 放射诊疗机构统一信用代码（无则传18个0）
    private String rhoEngineRoomId;         // 场所id（放射卫生在线数据库ID）
    private String zwyEngineRoomId;         // 场所id（外部数据库数据库ID）
    private String engineRoom;              // 场所名称（约定规则）
    private String engineRoomCode;          // 场所编码（由放射卫生在线系统产生）
    private String ifNoSealedSource;        // 是否使用非密封型放射性同位素（0-否；1-是）
    private String noSealedSourceId;        // if_no_sealed_source=1时必填，外部数据库非密封型放射性同位素id
    private String result;                  // 检测结果（1、合格；2、不合格）
    private String checkReportName;         // 检测报告名称（单个场所一份报告）
    private String checkReportNo;           // 检测报告编号（单个场所一份报告）
    private String checkReportUrl;          // 检测报告下载地址（单个场所一份报告）
    private String isInfulenceReport;       // 是否影响已推送报告（1、是；2否）
    private String dealType;                // 处理方式（1、替换内容；2、合并）
    private String optType;                 // 操作类型；1-新增；2-更新；3-删除
    private String oldSourceId;             // 更新或删除的数据id，更新删除时必填
    private String optReason;               // 更新或删除原因，更新删除时必填
    private Date   loadTime;                // 万达仓数据创建时间
    private String uniqueid;                // id_  + load_time

    private Integer syncErrType;            // 同步错误类型（0-去重忽略；1-正常同步；2-数据异常）
    private Integer dataErrType;            // 数据异常类型（待确定）
    private String  dataErrDesc;            // 数据异常类型描述（待确定）
}
