package cn.smarthse.rho.modules.sys.model.wanda.sync.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 医院：同步信息vo
 * </p>
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class HCSyncVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private String zwyId;

    private Long rhoId;

    private Long cid;

    //@ApiModelProperty(value = "姓名")
    private String name;

    //@ApiModelProperty(value = "身份证件类别")
    private String idcardType;

    //@ApiModelProperty(value = "身份证件号码")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idcardCode;

    //@ApiModelProperty(value = "性别编码")
    private String sexCode;

    //@ApiModelProperty(value = "出生日期 (yyyy-MM-dd)")
    private String birthday;

    //@ApiModelProperty(value = "工种编码")
    private String jobCode;

    //@ApiModelProperty(value = "放射工种编码")
    private String radiationType;

    //@ApiModelProperty(value = "体检机构名称")
    private String orgName;

    //@ApiModelProperty(value = "检查类型")
    private String checkType;

    //@ApiModelProperty(value = "体检类型编码")
    private String bodyCheckType;

    //@ApiModelProperty(value = "复检对应上次的职业健康档案编号")
    private String previousCardId;

    //@ApiModelProperty(value = "其他工种名称")
    private String otherJobName;

    //@ApiModelProperty(value = "总工龄年")
    private String seniorityYear;

    //@ApiModelProperty(value = "总工龄月")
    private String seniorityMonth;

    //@ApiModelProperty(value = "主检结论")
    private String checkResultCode;

    //@ApiModelProperty(value = "主检结果内容")
    private String conclusion;

    //@ApiModelProperty(value = "主检建议")
    private String suggest;

    //@ApiModelProperty(value = "体检日期 (yyyy-MM-dd)")
    private String checkTime;

    //@ApiModelProperty(value = "报告出具日期 (yyyy-MM-dd)")
    private String writeDate;

    //@ApiModelProperty(value = "报告编号")
    private String writeNo;

    //@ApiModelProperty(value = "放射诊疗机构名称统一社会信用代码 (无则传18个0)")
    private String creditCodeEmployer;

    //@ApiModelProperty(value = "放射诊疗机构名称名称")
    private String employerNameEmployer;

    //@ApiModelProperty(value = "放射诊疗机构名称id (职卫云)")
//    private String zwyEmployerId;

    //@ApiModelProperty(value = "放射诊疗机构名称id (放射卫生在线)")
    private String rhoEmployerId;

    //@ApiModelProperty(value = "适任性评价")
    private String adaptEvaluate;

    //@ApiModelProperty(value = "操作类型；1-新增；2-更新；3-删除")
//    private String optType;

    //@ApiModelProperty(value = "更新或删除的数据id，更新删除时必填")
//    private String oldSourceId;

    //@ApiModelProperty(value = "更新或删除原因，更新删除时必填")
//    private String optReason;

    //@ApiModelProperty(value = "万达仓数据创建时间")
    private LocalDateTime loadTime;

    //是否已经存在
    private Integer isExist;

    //是否异常数据0 否 1是 2异常但要同步 3缺少放射性危害因素
    private Integer isError;

    //@ApiModelProperty("异常描述")
    private String errorDes;

    //是否已转换（0-否，1-是, 2-异常）
    private Integer isConvertedRho;

    //是否重复推送（0-否，1-是，2-已重新转换）
    private Integer isRepeatedRho;

    //体检报告类型（1-职业健康体检、2-放射卫生体检、3-职业健康和放射卫生）
    private Integer checkReportType;

    private Integer isValid;

}
