package cn.smarthse.rho.modules.sys.model.wanda.sync.param;

import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达同步场所参数
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WandaSyncPlaceParam extends LayuiGridParam implements Serializable {
    private static final long serialVersionUID = 9052248507261114450L;

    /**
     * 查找的数据类型（1-新增；2-更新；3-删除）
     */
    private Integer searchType;

    private Date startTime;

    private Date endTime;



    public WandaSyncPlaceParam() {
    }

    public WandaSyncPlaceParam(Integer searchType) {
        this.searchType = searchType;
    }
}
