package cn.smarthse.rho.modules.sys.model.wanda.sync.param;

import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 万达同步参数
 * </p>
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WandaSyncParam extends LayuiGridParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private LocalDateTime hcSyncLimitTime;
    private Date startTime;

    private Date endTime;

    private Long trainingCertId;

    private Long doseId;

    private Long hcId;

    private Integer staffSourceHc = StaffSourceEnum.WAND_HC.getValue();
    private Integer staffSourceDose = StaffSourceEnum.WAND_DOSE.getValue();
    private Integer staffSourceTraining = StaffSourceEnum.HSE_TRAIN.getValue();

}
