package cn.smarthse.rho.modules.sys.model.wanda.push.param;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓推送 - 放射卫生在线 场所数据
 * @author chuhy
 * @date 2024/12/17 9:23
 */
@Data
public class WandaRhoPlacePushInfo implements Serializable {

    private static final long serialVersionUID = -2702096686562119650L;

    // 场所场所id (放射卫生在线)
    @JacksonXmlProperty(localName = "RHO_ENGINE_ROOM_ID")
    private String rhoEngineRoomId;

    // 场所场所id (外部数据库数据库id, 场所来源是外部数据; 非必填)
    @JacksonXmlProperty(localName = "ZWY_ENGINE_ROOM_ID")
    private String zwyEngineRoomId;

    // 放射诊疗机构id (放射卫生在线)
    @JacksonXmlProperty(localName = "RHO_HOSPITAL_ID")
    private String rhoHospitalId;

    // 放射诊疗机构id (外部数据库)
    @JacksonXmlProperty(localName = "ZWY_HOSPITAL_ID")
    private String zwyHospitalId;

    // 场所名称
    @JacksonXmlProperty(localName = "NAME")
    private String name;

    // 场所编号
    @JacksonXmlProperty(localName = "ROOM_CODE")
    private String roomCode;

    // 流水号
    @JacksonXmlProperty(localName = "SERIAL_NO")
    private String serialNo;

    // 是否为车载场所 (0-否；1-是)
    @JacksonXmlProperty(localName = "IS_ONBOARD")
    private String isOnboard;

    // 工作场所级别 (1-甲级；2-乙级；3-丙级)
    @JacksonXmlProperty(localName = "LEVELS")
    private String levels;

    // 许可状态 (0-未许可；1-已许可)
    @JacksonXmlProperty(localName = "LICENSE_STATUS")
    private String licenseStatus;

    // 最近一次许可校验/许可变更时间 (yyyy-MM-dd) (首次)
    @JacksonXmlProperty(localName = "LAST_LICENSE_TIME")
    private String lastLicenseTime;

    // 数据来源 (1-放射卫生在线，2-外部数据库)
    @JacksonXmlProperty(localName = "DATA_SOURCE")
    private String dataSource;

    // 操作类型；1-新增；2-更新；3-删除
    @JacksonXmlProperty(localName = "OPT_TYPE")
    private String optType;

    // 更新或删除的数据id，更新删除时必填
    @JacksonXmlProperty(localName = "OLD_SOURCE_ID")
    private String oldSourceId;

    // 更新或删除原因，更新删除时必填
    @JacksonXmlProperty(localName = "OPT_REASON")
    private String optReason;

    // 万达仓数据创建时间
    @JacksonXmlProperty(localName = "LOAD_TIME")
    private Date loadTime;
}