package cn.smarthse.rho.modules.sys.model.wanda.push.param;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓推送 - 放射卫生在线 设备数据
 * @author chuhy
 * @date 2024/12/17 9:23
 */
@Data
public class WandaRhoDevicePushInfo implements Serializable {
    private static final long serialVersionUID = 1032631114236019385L;

    // 设备id (放射卫生在线)
    @JacksonXmlProperty(localName = "RHO_DEVICE_ID")
    private String rhoDeviceId;

    // 设备id (外部数据库数据库id, 设备来源是外部数据库时必填)
    @JacksonXmlProperty(localName = "ZWY_DEVICE_ID")
    private String zwyDeviceId;

    // 放射诊疗机构id (放射卫生在线)
    @JacksonXmlProperty(localName = "RHO_HOSPITAL_ID")
    private String rhoHospitalId;

    // 放射诊疗机构id (外部数据库)
    @JacksonXmlProperty(localName = "ZWY_HOSPITAL_ID")
    private String zwyHospitalId;

    // (装置/核素)名称
    @JacksonXmlProperty(localName = "NAME")
    private String name;

    // (装置/核素)编号
    @JacksonXmlProperty(localName = "FACTORY_NO")
    private String factoryNo;

    // (装置/核素)生产厂家
    @JacksonXmlProperty(localName = "FACTORY")
    private String factory;

    // (装置/核素)状态 (1-正常；2-暂停使用；3-退役/报废)
    @JacksonXmlProperty(localName = "STATUS")
    private String status;

    // 类型 (1-射线装置；2-非密封放射性核素；3-密封放射性核素；4-含密封源装置)
    @JacksonXmlProperty(localName = "TYPE")
    private String type;

    // 许可证状态 (1-未许可；2-已许可)
    @JacksonXmlProperty(localName = "LICENSE_STATUS")
    private String licenseStatus;

    // 最近一次许可校验/许可变更时间 (yyyy-MM-dd) (首次发证还未到校检周期的，填写首次发证的时间)，已许可时必填
    @JacksonXmlProperty(localName = "LAST_LICENSE_TIME")
    private String lastLicenseTime;

    // 已许可状态类型 (1-正常；2-校验即将到期；3-校验已过期)
    @JacksonXmlProperty(localName = "LICENSE_STATUS_TYPE")
    private String licenseStatusType;

    // 预警状态 (21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
    @JacksonXmlProperty(localName = "WARNING_STATUS")
    private String warningStatus;

    // (装置)设备移动类型 (1-固定设备；2-移动设备；3-车载设备)
    @JacksonXmlProperty(localName = "MOBILITY_TYPE")
    private String mobilityType;

    // (装置)是否为床边机 (0-否；1-是 mobility_type为2时才有值)
    @JacksonXmlProperty(localName = "IS_BED_SIDE")
    private String isBedSide;

    // (装置)放射检查类型 (RayCheckTypeEnum)
    @JacksonXmlProperty(localName = "CHECK_TYPE")
    private String checkType;

    // (装置)放射诊疗类别 (英文逗号分隔DiagnosisTypeEnum)
    @JacksonXmlProperty(localName = "DIAGNOSIS_TYPE")
    private String diagnosisType;

    // (装置)型号
    @JacksonXmlProperty(localName = "MODEL")
    private String model;

    // (装置)球管个数
    @JacksonXmlProperty(localName = "BULB_NUM")
    private Integer bulbNum;

    // (装置)安装单位
    @JacksonXmlProperty(localName = "INSTALLATION_UNIT")
    private String installationUnit;

    // (装置/核素)负责人
    @JacksonXmlProperty(localName = "PERSON_IN_CHARGE")
    private String personInCharge;

    // (装置/核素)出厂日期
    @JacksonXmlProperty(localName = "PRODUCTION_DATE")
    private String productionDate;

    // (核素)用途
    @JacksonXmlProperty(localName = "USE_TO")
    private String useTo;

    // 物理状态 (1-固态；2-液态；3-气态)
    @JacksonXmlProperty(localName = "PHYSICAL_STATE")
    private String physicalState;

    // (核素)最大等效日操作量 (底数，保留两位小数)
    @JacksonXmlProperty(localName = "DAILY_DATA1")
    private String dailyData1;

    // (核素)最大等效日操作量 (指数)
    @JacksonXmlProperty(localName = "DAILY_DATA2")
    private String dailyData2;

    // (核素)最大等效年操作量 (底数，保留两位小数)
    @JacksonXmlProperty(localName = "YEAR_DATA1")
    private String yearData1;

    // (核素)最大等效年操作量 (指数)
    @JacksonXmlProperty(localName = "YEAR_DATA2")
    private String yearData2;

    // (核素)出厂活度 (底数，保留两位小数)
    @JacksonXmlProperty(localName = "FACTORY_ACTIVITY_DATA1")
    private String factoryActivityData1;

    // (核素)出厂活度 (指数)
    @JacksonXmlProperty(localName = "FACTORY_ACTIVITY_DATA2")
    private String factoryActivityData2;

    // (核素)活度测量日期 (yyyy-MM-dd)
    @JacksonXmlProperty(localName = "MEASUREMENT_DATE")
    private String measurementDate;

    // (核素)国家编码
    @JacksonXmlProperty(localName = "NUCLIDE_UNIQUE_CODE")
    private String nuclideUniqueCode;

    // 数据来源 (1-放射卫生在线，2-外部数据库)
    @JacksonXmlProperty(localName = "DATA_SOURCE")
    private String dataSource;

    // 操作类型；1-新增；2-更新；3-删除
    @JacksonXmlProperty(localName = "OPT_TYPE")
    private String optType;

    // 更新或删除的数据id，更新删除时必填
    @JacksonXmlProperty(localName = "OLD_SOURCE_ID")
    private String oldSourceId;

    // 更新或删除原因，更新删除时必填
    @JacksonXmlProperty(localName = "OPT_REASON")
    private String optReason;

    // 万达仓数据创建时间
    @JacksonXmlProperty(localName = "LOAD_TIME")
    private Date loadTime;


    public void setModel(String model) {
        if (model != null) {
            // 移除控制字符（0x00-0x1F，除了制表符、换行符、回车符）
            this.model = model.replaceAll("[\\x00-\\x08\\x0B-\\x0C\\x0E-\\x1F]", "");
        } else {
            this.model = null;
        }
    }

    public void setFactoryNo(String factoryNo) {
        if (factoryNo != null) {
            // 移除控制字符（0x00-0x1F，除了制表符、换行符、回车符）
            this.factoryNo = factoryNo.replaceAll("[\\x00-\\x08\\x0B-\\x0C\\x0E-\\x1F]", "");
        } else {
            this.factoryNo = null;
        }
    }
}

