package cn.smarthse.rho.modules.sys.model.third.param;

import jakarta.validation.Valid;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 三方接口 - 新增设备参数
 */
@Data
public class ThirdDeviceDto implements Serializable{
	private static final long serialVersionUID = -5440999278622524674L;

	@Valid
	//@ApiModelProperty(value = "设备基础信息")
	private ThirdDeviceBaseDto deviceBaseDto;

	//@ApiModelProperty(value = "射线装置信息")
	private ThirdDeviceRayDto deviceRayDto;

	//@ApiModelProperty(value = "含密封源装置")
	private ThirdDeviceSourceDto deviceSourceDto;

	//@ApiModelProperty(value = "密封性核素")
	private ThirdSourceSealedDto sourceSealedDto;

	//@ApiModelProperty(value = "非密封放射性核")
	private ThirdSourceNonSealedDto sourceNonSealedDto;

	//@ApiModelProperty(value = "核素-机房-装置对应关系list")
	private List<ThirdDeviceRelationDto> relationDtoList;

}
