package cn.smarthse.rho.modules.sys.model.third.param;

import jakarta.validation.constraints.NotEmpty;
import lombok.Data;

import java.io.Serializable;

/**
 * 三方接口 - 设备基础信息参数
 */
@Data
public class ThirdDeviceBaseDto implements Serializable{
	private static final long serialVersionUID = -6877778945899044290L;


	/**
	 * 医院唯一码
	 */
	@NotEmpty(message = "医院唯一码不能为空")
	//@ApiModelProperty(value = "医院唯一码",required = true)
	private String uniqueCode;

	//@ApiModelProperty(value = "设备id")
	private Long id;

	/**
	 * 设备名称
	 */
	//@ApiModelProperty(value = "设备名称",required = true)
	private String name;
	
	/**
	 * 设备编号
	 */
	//@ApiModelProperty(value = "设备编号",required = true)
	private String factoryNo;

	/**
	 * 生产厂家
	 */
	//@ApiModelProperty(value = "生产厂家",required = true)
	private String factory;

	/**
	 * 状态（1-正常；2-暂停使用；3-退役/报废）
	 */
	//@ApiModelProperty(value = "状态（1-正常；2-暂停使用；3-退役/报废）",required = true)
	private Integer status;

	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	//@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）",required = true)
	private Integer type;

	/**
	 * (核素)用途
	 */
	//@ApiModelProperty(value = "(核素)用途")
	private String useTo;

	// /**
	//  * 所在机房/场所id
	//  */
	// //@ApiModelProperty(value = "所在机房/场所id")
	// private Long locationId;

	/**
	 * 所在机房/场所name
	 */
	//@ApiModelProperty(value = "所在机房/场所name")
	private String locationName;

	// /**
	//  * 许可状态(1-未许可；2-已许可；3-许可注销)
	//  */
	// //@ApiModelProperty(value = "许可状态(1-未许可；2-已许可；3-许可注销)")
	// private Integer licenseStatus;
	//
	// /**
	//  * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	//  */
	// //@ApiModelProperty(value = "已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
	// private Integer licenseStatusType;
	//
	// /**
	//  * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	//  */
	// //@ApiModelProperty(value = "预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)")
	// private Integer warningStatus;

	/**
	 * (装置)使用科室
	 */
	//@ApiModelProperty(value = "(装置)使用科室")
	private Long useDepartmentId;
}
