package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 监管端：系统模块-单位用户详情
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/4 16:42
 */
public @Data class SysUserCompanyOneForSupVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private Long id;

    //@ApiModelProperty(value = "账号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    private Long cid;

    //@ApiModelProperty("所在医院名称")
    private String hospitalName;

    //@ApiModelProperty(value = "院区名")
    private String branchName;

    //@ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    //@ApiModelProperty("全国统一码")
    private String medicalNucode;

    private String address;

    //@ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属")
    private Integer belongType;

    //@ApiModelProperty(value = "监督单位id")
    private Long supervisionUnit;
    private String supervisionUnitStr;

    //@ApiModelProperty("是否是测试")
    private Integer isTest;

    /**
     * 营业状态
     */
    private Integer businessStatus;

    /**
     * 是否禁用(1-禁用，0-启用)
     */
    private Integer isForbidden;

    /**
     * 账号启用禁用时间
     */
    private LocalDateTime forbiddenUpdateTime;

    private Integer licenceStatus;

    /**
     * 是否启用多执业地址模式  0普通 1多执业地址
     */
    private Integer addressType;

    private Long companyAddressId;

    private List<CompanyAddressVo> companyAddressList;

    /**
     * 监督管辖类型（0-属地管辖 1-特殊管辖）
     */
    private Integer supervisoryJurisdictionType;

    private Long areaId;
    private SysAreaVo sysArea;
    private Long statisticsAreaId;
    private SysAreaVo statisticsSysArea;

}
