package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.modules.sys.model.sys.param.SysRoleDto;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 医院端：系统模块-单位用户详情
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/4 16:42
 */
@Accessors(chain = true)
public @Data class SysUserCompanyOneForComVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    //@ApiModelProperty(value = "账号")
    private String username;

    //@ApiModelProperty(value = "昵称")
    private String nickname;

    //@ApiModelProperty(value = "角色(id与name)")
    private List<SysRoleDto> roleList;

    //@ApiModelProperty(value = "手机号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String tel;

    //@ApiModelProperty(value = "职务")
    private String post;

    //@ApiModelProperty(value = "部门")
    private String department;

    //@ApiModelProperty(value = "是否禁用(1-禁用，0-启用)")
    private Integer isForbidden;

}
