package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 单位用户列表dto
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/5/15 13:18
 */
public @Data class SysUserCompanyListForSupVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private Long id;

    //@ApiModelProperty(value = "账号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    private Long cid;

    //@ApiModelProperty("所在医院名称")
    private String hospitalName;

    //@ApiModelProperty(value = "院区名")
    private String branchName;

    //@ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    //@ApiModelProperty(value = "行政区划id")
    private Long areaId;

    //@ApiModelProperty(value = "行政区划")
    private String areaName;

    private String provinceName;
    private String cityName;
    private String districtName;
    private String streetName;

    //@ApiModelProperty(value = "是否禁用(1-禁用，0-启用)")
    private Integer isForbidden;

    //@ApiModelProperty(value = "营业状态")
    private Integer businessStatus;

    /**
     * CompanyLicenceStatusEnum
     */
    private Integer licenceStatus;

    /**
     * 是否启用多执业地址模式  0普通 1多执业地址
     */
    private Integer addressType;

    /**
     * 入库时间
     */
    private LocalDateTime entryTime;

    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String bindName;
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String bindTel;

    public String getAreaName() {
        StringBuilder result = new StringBuilder();
        if (StringUtils.hasText(this.getProvinceName())) {
            result.append(this.getProvinceName());
        }
        if (StringUtils.hasText(this.getCityName())) {
            result.append(">");
            result.append(this.getCityName());
        }
        if (StringUtils.hasText(this.getDistrictName())) {
            result.append(">");
            result.append(this.getDistrictName());
        }
        if (StringUtils.hasText(this.getStreetName())) {
            result.append(">");
            result.append(this.getStreetName());
        }
        return result.toString();
    }

}
