package cn.smarthse.rho.modules.sys.model.sys.vo;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 装置类型树形结构
 * @author chuhy
 * @date 2025/7/9 13:49
 */
@Data
public class SysTreeNode implements Serializable {
    @Serial
    private static final long serialVersionUID = 3130873820588102080L;

    // id
    private Long value;
    // name
    private String label;
    private List<SysTreeNode> children = new ArrayList<>();

    public SysTreeNode() {
    }

    public SysTreeNode(Long id, String label) {
        this.value = id;
        this.label = label;
    }

    public SysTreeNode(Long id, String label, List<SysTreeNode> children) {
        this.value = id;
        this.label = label;
        this.children = children;
    }

    public void addChild(SysTreeNode child) {
        this.children.add(child);
    }
}
