package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.rho.modules.sys.utils.NeutronNameUtil;
import lombok.Data;

import java.io.Serializable;

/**
 * 核素vo
 */
@Data
public class SysElementVo implements Serializable{
	private static final long serialVersionUID = 575589918383268506L;


	/**
	 * 名称
	 */
	private String name;

	/**
	 * 符号
	 */
	private String symbol;

	/**
	 * 质子数
	 */
	private Integer protonNumber;

	/**
	 * 同位素标记
	 */
	private String neutrons;

	/**
	 * 核素状态
	 */
	private String energyState;

	/**
	 * 毒性因子
	 */
	private Float harmFactor;

	private String formatName;

	public String getFormatName() {
		// ¹³²ᵐI(气态或蒸汽态)

		return NeutronNameUtil.formatName(symbol, neutrons, energyState);
	}

}
