package cn.smarthse.rho.modules.sys.model.sys.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;



/**
 * <p>
 * 医院：基础信息Vo
 * </p>
 *
 * @author chenliang
 * @since 2024-03-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value = "BCompanyVo对象", description = "医院：基础信息")
public class BCompanyChooseVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("院区id")
    private Long id;
    //@ApiModelProperty("院区名称")
    private String name;

    //@ApiModelProperty("统一社会信用代码")
    private String creditCode;

    //@ApiModelProperty("所在医院名称")
    private String hospitalName;

    @JsonInclude(value = JsonInclude.Include.NON_EMPTY)
    private List<BCompanyChooseVo> children = new ArrayList<>();

}
