package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.rho.core.framework.model.UserEditParam;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 监管端：系统管理-用户管理 编辑
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/3 10:17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SysCompanyUserEditForSupParam extends UserEditParam {

    @Serial
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 账号名称
     */
    private String username;

    /**
     * 院区名
     */
    @NotBlank(message = "院区名不能为空")
    private String branchName;

    /**
     * 统一社会信用代码
     */
    private String creditCode;

    @NotNull(message = "cid不能为空")
    //@ApiModelProperty(value = "cid", required = true)
    private Long cid;

    private Long areaId;
    private Long statisticsAreaId;

    @NotNull(message = "直属类型不能为空")
    //@ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属", required = true)
    private Integer belongType;

    //@NotNull(message = "是否是测试不能为空")
    //@ApiModelProperty(value = "是否是测试", required = true)
    private Integer isTest;

    /**
     * 是否启用多执业地址模式  0普通 1多执业地址
     */
    @NotNull(message = "是否启用多执业地址模式不能为空")
    private Integer addressType;

    /**
     * 监督管辖类型（0-属地管辖 1-特殊管辖）
     */
    @NotNull(message = "监督管辖类型不能为空")
    private Integer supervisoryJurisdictionType;

}
