package cn.smarthse.rho.modules.sys.model.s.vo;

import cn.smarthse.framework.json.utils.JsonUtils;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.enums.s.SuperviseLawYrdwJcjgEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 监督数据列表model
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@Data
public class SupervisionListVo implements Serializable {

    private static final long serialVersionUID = 3370294503456566074L;

    //@ApiModelProperty(value = "id")
    private Long id;

    //@ApiModelProperty(value = "分院id")
    private Long cid;

    //@ApiModelProperty(value = "主院名称")
    private String compMainName;

    //@ApiModelProperty(value = "分院名称")
    private String compName;

    //@ApiModelProperty(value = "信用代码")
    private String creditCode;

    //@ApiModelProperty(value = "所在地区")
    private String areaName;

    //@ApiModelProperty(value = "监督日期")
    private Date supDate;

    //@ApiModelProperty(value = "监督类别")
    private String type;

    //@ApiModelProperty(value = "监督员1")
    private String supervisor1;

    //@ApiModelProperty(value = "监督员2")
    private String supervisor2;

    //@ApiModelProperty(value = "监督单位")
    private String supervisionUnit;

    //@ApiModelProperty(value = "检查结果")
    private String yrdwJcjg;

    //@ApiModelProperty(value = "采取行为")
    private String cqxw;

    //@ApiModelProperty(value = "检查项")
    @JsonIgnore
    private String jcx;

    //@ApiModelProperty(value = "检查项")
    private List<JsonJcxVo> cqxwList;

    public String getYrdwJcjg() {
        if (StringUtils.isNotEmpty(yrdwJcjg)) {
            return SuperviseLawYrdwJcjgEnum.getNameByCode(this.yrdwJcjg);
        }
        return "";
    }

    public List<JsonJcxVo> getCqxwList() {
        if (StringUtils.isNotEmpty(jcx)) {
            return JsonUtils.parseArray(jcx, JsonJcxVo.class);
        }
        return null;
    }
}
