package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * source风险DTO。
 * 用于批量验收的导出和导入使用
 */
@Data
public class RiskSourceForExportDto {

    /**
     *    sourceId
     */
    @ExcelProperty(value = "编号(请勿修改)")
    @ColumnWidth(20)
    private Long id;

    /**
     *    cid
     */
    @ExcelIgnore
    private Long cid;

    /**
     *    对应工作id
     */
    @ExcelIgnore
    private Long businessId;

    /**
     * 细分业务id（譬如体检，subBusinessId为具体到人员的id，此时businessId存的是对应的体检id）
     */
    @ExcelIgnore
    private Long subBusinessId;

    /**
     * 三同时detail1Id
     */
    @ExcelIgnore
    private Long projectDetail1Id;

    /**
     * 三同时detail2Id
     */
    @ExcelIgnore
    private Long projectDetail2Id;

    /**
     * 画像审核id
     */
    @ExcelIgnore
    private Long keyFactoryAuditId;

    /**
     *    风险名称
     */
    @ExcelProperty(value = "风险名称")
    @ColumnWidth(35)
    private String name;

    /**
     *    风险类型 （RiskTypeEnum）
     */
    @ExcelIgnore
    private Integer type;

    /**
     *    发现时间
     */
    @ExcelIgnore
    private Date findTime;

    /**
     * 整改提交时间
     */
    @ExcelProperty(value = "整改提交时间")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(20)
    private LocalDateTime submitTime;

    /**
     * 佐证材料类型(AcceptanceMaterialsTypeEnum)
     */
    @ExcelIgnore
    private Integer materialsType;

    /**
     * 整改相关资料/佐证材料IDS
     */
    @ExcelIgnore
    private String reformFinishedFiles;

    /**
     * 整改相关资料/佐证材料URL
     */
    @ExcelIgnore
    private List<SysFileVo> reformFinishedFilesURL;

    /**
     * 整改措施
     */
    @ExcelProperty(value = "整改措施")
    @ColumnWidth(100)
    private String reformMeasure;

    /**
     * 验收时间
     */
    @ExcelIgnore
    private LocalDate acceptanceDate;

    /**
     *    整改状态（0-草稿；1-未化解；2-已化解；3-已中止）
     */
    @ExcelIgnore
    private Integer status;

    /**
     * 未化解状态(0-无；11-待整改；12-待验收；13-已退回)
     */
    @ExcelIgnore
    private Integer unresolvedType;

    /**
     *    预警状态（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）
     */
    @ExcelIgnore
    private Integer warningStatus;

    /**
     * 设备类型，用于给前端进行跳转页面使用（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
     */
    @ExcelIgnore
    private Integer deviceType;

}
