package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@AllArgsConstructor
@NoArgsConstructor
public class RiskDefuseDto implements Serializable{
    private static final long serialVersionUID = 1L;

    //风险id
    private Long riskId;

    //验收方式
    private Integer acceptanceWay = RiskAcceptanceWayEnum.DATA.getValue();

    //整改措施
    private String reformMeasure;

    public static RiskDefuseDto createCommonDefuse(Long riskId){
        return new RiskDefuseDto(riskId, RiskAcceptanceWayEnum.DATA.getValue(), "NULL");
    }
    public static RiskDefuseDto createSpecialDefuse(Long riskId){
        return new RiskDefuseDto(riskId, RiskAcceptanceWayEnum.SPECIAL_FOREVER.getValue(), "NULL");
    }

    public static RiskDefuseDto createCommonMeasuresDefuse(Long riskId, String measures){
        return new RiskDefuseDto(riskId, RiskAcceptanceWayEnum.DATA.getValue(), measures);
    }

    public static RiskDefuseDto createSpecialMeasuresDefuse(Long riskId, String measures){
        return new RiskDefuseDto(riskId, RiskAcceptanceWayEnum.SPECIAL_FOREVER.getValue(), measures);
    }


}
