package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


@Data
public class RiskAcceptanceHistoryVo implements Serializable{

	@Serial
	private static final long serialVersionUID = 4256638448748476123L;

	
	/**
	 * r_risk_basic.id
	 */
	private Long riskId;

	/**
	 * r_risk_basic_source.id
	 */
	private Long sourceId;

	/**
	 * r_risk_acceptance_record.id
	 */
	private Long accId;
	
	/**
	 * 企业ID
	 */
	private Long cid;
	
	/**
	 * 整改负责人姓名（冗余）
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String reformDirectorName;
	
	/**
	 * 要求完成时间/整改期限
	 */
	private LocalDate requireFinishTime;
	
	/**
	 * 实际完成时间
	 */
	private LocalDate actualFinishTime;

	/**
	 * 整改提交时间
	 */
	private LocalDateTime submitTime;

	/**
	 * 佐证材料类型(AcceptanceMaterialsTypeEnum)
	 */
	private Integer materialsType;
	
	/**
	 * 整改相关资料/佐证材料
	 */
	private String reformFinishedFiles;
	/**
	 * 整改相关资料/佐证材料URL
	 */
	private List<SysFileVo> reformFinishedFilesURL;
	
	/**
	 * 整改措施
	 */
	private String reformMeasure;
	
	/**
	 * 状态（0-草稿；1-待审核；2-无需整改；3-完成)
	 */
	private Integer status;
	
	/**
	 * 验收结论（1-通过；0-不通过）
	 */
	private Integer acceptanceResult;
	
	/**
	 * 验收结论说明
	 */
	private String acceptanceResultExplain;
	
	/**
	 * 验收负责人姓名（冗余）
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String acceptanceDirectorName;
	
	/**
	 * 验收时间
	 */
	private LocalDate acceptanceDate;

	/**
	 * 验收方式（1-数据化解;2-佐证材料化解；3-佐证材料永久化解；4-特殊化解）
	 */
	private Integer acceptanceWay;
	
	/**
	 * 验收相关资料
	 */
	private String acceptanceFiles;
	/**
	 * 整改相关资料/佐证材料URL
	 */
	private List<SysFileVo> acceptanceFilesURL;
	
	/**
	 * 诊断/体检机构id
	 */
	private Long thirdOrgId;
	
	/**
	 * 诊断/体检机构名称
	 */
	private String thirdOrgName;
	
	/**
	 * 诊断、体检时间开始
	 */
	private LocalDate dealTimeBegin;
	
	/**
	 * 处理措施
	 */
	private Integer dealMeasure;
	
	/**
	 * 诊断、体检时间结束
	 */
	private LocalDate dealTimeEnd;

	/**
	 * 体检-最近一次体检类型： 1-岗前，2-在岗，3-离岗，
	 */
	private Integer healthLastType;

	/**
	 * 体检-最近一次体/检测检时间
	 */
	private LocalDate businessLastDate;
	/**
	 * 体检-最近一次体检/复查/检测/个人剂量监测机构名称
	 */
	private String businessLastOrg;

}
