package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.modules.sys.enums.health.HealthHazardFactorsEnum;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceMaterialsTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


@Data
public class RiskAcceptanceCommonVo implements Serializable{

	@Serial
	private static final long serialVersionUID = 3258253815120182780L;

	private Long id;
	
	/**
	 * r_risk_basic.id
	 */
	private Long riskId;

	/**
	 * r_risk_basic_source.id
	 */
	private Long sourceId;

	/**
	 * r_risk_acceptance_record.id
	 */
	private Long accId;
	
	/**
	 * 企业ID
	 */
	private Long cid;

	/**
	 * 整改提交时间
	 */
	private LocalDateTime findTime;
	
	/**
	 * 整改负责人姓名（冗余）
	 */
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	@Desensitization(type = DesensitizationType.NAME)
	private String reformDirectorName;
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String reformDirectorNamePlaintext;
	
	/**
	 * 要求完成时间/整改期限
	 */
	private LocalDate requireFinishTime;
	
	/**
	 * 实际完成时间
	 */
	private LocalDate actualFinishTime;

	/**
	 * 整改提交时间
	 */
	private LocalDateTime submitTime;

	/**
	 * 佐证材料类型(AcceptanceMaterialsTypeEnum)
	 */
	private Integer materialsType;
	private String materialsTypeStr;

	
	/**
	 * 整改相关资料/佐证材料
	 */
	private String reformFinishedFiles;
	/**
	 * 整改相关资料/佐证材料URL
	 */
	private List<SysFileVo> reformFinishedFilesURL;
	
	/**
	 * 整改措施
	 */
	private String reformMeasure;
	
	/**
	 * 状态（0-草稿；1-待审核；2-无需整改；3-完成)
	 */
	private Integer status;
	
	/**
	 * 验收结论（1-通过；0-不通过）
	 */
	private Integer acceptanceResult;
	
	/**
	 * 验收结论说明
	 */
	private String acceptanceResultExplain;
	
	/**
	 * 验收负责人姓名（冗余）
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String acceptanceDirectorName;
	
	/**
	 * 验收时间
	 */
	private LocalDate acceptanceDate;
	
	/**
	 * 验收相关资料
	 */
	private String acceptanceFiles;
	/**
	 * 整改相关资料/佐证材料URL
	 */
	private List<SysFileVo> acceptanceFilesURL;
	
	/**
	 * 诊断/体检机构id
	 */
	private Long thirdOrgId;
	
	/**
	 * 诊断/体检机构名称
	 */
	private String thirdOrgName;
	
	/**
	 * 诊断、体检时间开始
	 */
	private LocalDate dealTimeBegin;
	
	/**
	 * 处理措施
	 */
	private Integer dealMeasure;
	
	/**
	 * 诊断、体检时间结束
	 */
	private LocalDate dealTimeEnd;

	/**
	 * 体检-最近一次体检类型： 1-岗前，2-在岗，3-离岗，
	 */
	private Integer healthLastType;
	private String healthLastTypeStr;

	/**
	 * 体检-最近一次体/检测检时间
	 */
	private LocalDate businessLastDate;
	/**
	 * 体检-最近一次体检/复查/检测/个人剂量监测机构名称
	 */
	private String businessLastOrg;
	// /**
	//  * 最近一次 体检/检测 时间
	//  */
	// private LocalDate healthRecheckDate;
	/**
	 * 个人剂量-最近一次监测周期（开始）
	 */
	private LocalDate doseMonitorLastStartDate;
	/**
	 * 个人剂量-最近一次监测周期（结束）
	 */
	private LocalDate doseMonitorLastEndDate;
	/**
	 * 个人剂量-最近一次监测结果：小数
	 */
	private String doseLastResult;
	/**
	 * 最近一次 体检危害因素名称
	 */
	private String healthLastHazardFactor;
	/**
	 * 最近一次 体检危害因素名称
	 */
	private String healthLastHazardFactorStr;
	/**
	 * 最近一次 体检结论
	 */
	private String healthLastCheckConclusion;
	/**
	 * 最近一次 体检适任性评价
	 */
	private String healthLastCheckAssessment;
	/**
	 * 检测-最近一次检测类型：1验收（控评）检测；2-状态（年度）检测；3-稳定性检测
	 */
	private Integer checkLastType;
	/**
	 * 检测-最近一次检测报告编号
	 */
	private String checkLastReportNo;
	/**
	 * 检测-最近一次检测结果：1-合格；0-不合格
	 */
	private Integer checkLastResult;
	/**
	 * 体检-离岗 时间
	 */
	private LocalDate offWorkDate;
	/**
	 * 暂时离岗 时间
	 */
	private LocalDate tempOffWorkDate;
	/**
	 * 暂时离岗 返岗时间
	 */
	private LocalDate tempReturnWorkDate;
	/**
	 * 许可-最近一次校验许可证号
	 */
	private String licenseLastNo;


	public String getMaterialsTypeStr() {

		return AcceptanceMaterialsTypeEnum.getName(this.materialsType);
	}

	public String getHealthLastTypeStr() {

		return RiskPostStatusEnum.getName(this.healthLastType);
	}

	public String getHealthLastHazardFactorStr() {

		return HealthHazardFactorsEnum.getName(this.healthLastHazardFactor);
	}
}
