package cn.smarthse.rho.modules.sys.model.r.param;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;

/**
 * 风险查询参数
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SearchRiskParam implements Serializable{
    @Serial
    private static final long serialVersionUID = -2806425095410388664L;

    /**
     * year
     */
    private Integer year;

    /**
     * cid
     */
    private Long cid;

    /**
     * 业务id
     */
    private Long businessId;

    /**
     * 细分业务id（譬如体检，subBusinessId为具体到人员的id，此时businessId存的是对应的体检id）
     */
    private Long subBusinessId;

    /**
     * 风险类型(RiskTypeEnum)
     */
    private Integer type;

    /**
     * 风险类别(RiskCategoryEnum)
     */
    private Integer category;

    /**
     * 体检-岗位(PostTypeEnum)
     */
    private Integer postType;

    /**
     * 体检-岗中岗位状态
     */
    private Integer postSubType;

    /**
     * 是否由数据产生的风险（0-否；1-是）
     */
    private Integer isGenerateByData;

}
