package cn.smarthse.rho.modules.sys.model.r.param;

import cn.smarthse.rho.core.framework.model.HeadPageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 风险化解管理清单 - 参数
 *
 * @author chuhy
 * @date 2024/6/26 15:05
 */
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@Data
public class RiskQueryCommonParam extends HeadPageParam {

    /**
     * 风险basicId
     */
    private Long basicId;

    /**
     * 风险sourceId
     */
    private Long sourceId;

    /**
     * 文件id
     */
    private Long fileId;

    /**
     * 统一社会信用代码
     */
    private String creditCode;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 风险类型 RiskTypeEnum
     */
    private List<Integer> riskTypeList;

    /**
     * 类别（1-普通八项；2-异常六项）
     */
    private Integer category;

    /**
     * 状态（1-未化解；2-已化解；3-已中止）
     */
    private Integer status;

    /**
     * 未化解状态(0-无；11-待整改；12-待验收；13-已退回)
     */
    private Integer unresolvedType;

    /**
     * 预警状态（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）
     */
    private Integer warningStatus;

    /**
     * 包含暂停营业的医院（0-不包含暂停营业；1-包含暂停营业）
     */
    private Integer isConcludeSuspend;
}
