package cn.smarthse.rho.modules.sys.model.r.param;

import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 风险维护参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RiskManagerDefuseParam implements Serializable{
    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("年份")
    private Integer year;

    //@ApiModelProperty("医院id")
    private List<Long> cidList;

    //@ApiModelProperty("有效时间间隔(年)")
    private Integer effectiveYear = 2;

    //@ApiModelProperty("有效时间间隔(年)")
    private Integer doseEffectiveMonth = 3;

    //@ApiModelProperty("岗位状态（在岗 1）")
    private Integer postStatus = PostStatusEnum.NON_POST.getValue();

    private Integer riskPrePostStatus = RiskPostStatusEnum.PRE_POST.getValue();
    private Integer riskOnPostStatus = RiskPostStatusEnum.ON_POST.getValue();
    private Integer riskDtPostStatus = RiskPostStatusEnum.DT_POST.getValue();

    //@ApiModelProperty("健康风险枚举value")
    private Integer healthRiskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
    private Integer cmCertRiskType = RiskTypeEnum.LICENSE_MANAGEMENT.getValue();
    private Integer trainingRiskType = RiskTypeEnum.TRAINING.getValue();
    private Integer doseRiskType = RiskTypeEnum.DOSE_MONITORING.getValue();


}
