package cn.smarthse.rho.modules.sys.model.r.param;

import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * 化解风险通用接口 - 化解风险参数
 * @author chuhy
 * @date 2024/7/29 16:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ResolveRiskForCommonParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -4620924325422006338L;

    /**
     * source风险ids
     */
    private List<Long> sourceIdList;

    /**
     * 验收结论(注意！因为沟通失误，这个字段本意是整改措施，但实际上这个值设置到了验收结论中。)
     */
    private String reformMeasure;

    /**
     * 整改措施
     */
    private String realReformMeasure;

    /**
     * 验收方式（RiskAcceptanceWayEnum）
     */
    private Integer acceptanceWay = RiskAcceptanceWayEnum.DATA.getValue();






    public ResolveRiskForCommonParam() {
    }

    public ResolveRiskForCommonParam(List<Long> sourceIdList) {
        this.sourceIdList = sourceIdList;
    }

    public ResolveRiskForCommonParam(List<Long> sourceIdList, String reformMeasure) {
        this.sourceIdList = sourceIdList;
        this.reformMeasure = reformMeasure;
    }

    public ResolveRiskForCommonParam(List<Long> sourceIdList, Integer acceptanceWay) {
        this.sourceIdList = sourceIdList;
        this.acceptanceWay = acceptanceWay;
    }

    public ResolveRiskForCommonParam(List<Long> sourceIdList, String reformMeasure, Integer acceptanceWay) {
        this.sourceIdList = sourceIdList;
        this.reformMeasure = reformMeasure;
        this.acceptanceWay = acceptanceWay;
    }
}
