package cn.smarthse.rho.modules.sys.model.m.vo;

import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 吴嘉诚
 * @date 2022/9/22 10:08
 * @desc
 */
public @Data class OnlineMonitoringDeviceModel implements Serializable {

    //@ApiModelProperty("设备ID")
    private Long id;

    //@ApiModelProperty("设备名称")
    private String deviceName;

    //@ApiModelProperty("设备类型 0-化学毒物,1-粉尘,2-噪声,3-监控,4-高温,5-电离辐射,6-其他危害因素")
    private String type;
    //@ApiModelProperty("设备类型")
    private String typeStr;

    //@ApiModelProperty("设备状态 0-正常,1-报警,2-离线")
    private Byte status;
    //@ApiModelProperty("设备状态")
    private String statusStr;

    private String provinceName;
    private String cityName;
    private String areaName;
    private String streetName;
    private String areaDetailName;

    private Long cid;

    //@ApiModelProperty("安装企业")
    private String companyName;

    //@ApiModelProperty("安装位置")
    private String position;

    //@ApiModelProperty("监测的危害因素ID")
    private Long factorId;

    //@ApiModelProperty("监测的危害因素名称")
    private String factorName;

    //@ApiModelProperty("监测值")
    private String earlyWarning;

    //@ApiModelProperty("报警值")
    private String alarmVdata;

    //@ApiModelProperty("最后一次报警时间")
    private Date latestAlarmDate;

    //@ApiModelProperty("设备ID")
    private String latestAlarmDateStr;

    //@ApiModelProperty("设备接入时间")
    private Date deviceAccessTime;

    //@ApiModelProperty("设备变更时间")
    private Date deviceUpdateTime;

    private String dataType;    //数据类型（粉尘使用 1002-总尘，1003-呼尘）

    private Boolean isValid;


    /*public String getTypeStr() {
        String typeValue = this.getType();
        return DeviceTypeEnum.getTypeNameByValue(typeValue);
    }*/

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        if (status == 0) {
            this.statusStr = "正常";
        } else if (status == 1) {
            this.statusStr = "报警";
        } else if (status == 2) {
            this.statusStr = "离线";
        } else {
            this.statusStr = null;
        }
        this.status = status;
    }

    /**
     * 设置行政区划详情
     *
     * @param spliter 分隔符
     */
    public void settingDetailName(String spliter) {
        StringBuffer fullName = new StringBuffer();
        String provinceName = this.getProvinceName();
        String cityName = this.getCityName();
        String areaName = this.getAreaName();
        String streetName = this.getStreetName();
        if (StringUtils.hasText(provinceName)) {
            fullName.append(provinceName);
        }
        if (StringUtils.hasText(cityName)) {
            fullName.append(spliter);
            fullName.append(cityName);
        }
        if (StringUtils.hasText(areaName)) {
            fullName.append(spliter);
            fullName.append(areaName);
        }
        if (StringUtils.hasText(streetName)) {
            fullName.append(spliter);
            fullName.append(streetName);
        }
        this.setAreaDetailName(fullName.toString());
    }

}
