package cn.smarthse.rho.modules.sys.model.home.vo;

import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 单位端：首页可视化-放射诊疗许可证信息：许可证信息
 *
 * @author wuxq
 * @since 2024/6/6 13:56
 */
@Data
public class HomeData41 implements Serializable {

    private static final long serialVersionUID = -1L;

    //@ApiModelProperty(value = "证书id")
    private Long id;

    //@ApiModelProperty(value = "证书名称")
    private String name;

    //@ApiModelProperty(value = "发证日期")
    private LocalDateTime beginDate;

    //@ApiModelProperty(value = "失效日期")
    private LocalDateTime endDate;

    //@ApiModelProperty(value = "最近一次校验日期")
    private LocalDateTime lastVerificationDate;

    //@ApiModelProperty(value = "下一次校验日期")
    private LocalDateTime nextVerificationDate;

    //@ApiModelProperty(value = "许可项目")
    private String r;

    //@ApiModelProperty(value = "X射线影像诊断")
    private String r1;

    //@ApiModelProperty(value = "介入放射学")
    private String r2;

    //@ApiModelProperty(value = "核医学")
    private String r3;

    //@ApiModelProperty(value = "放射治疗")
    private String r4;

    public String getR() {
        if(!StringUtils.isEmpty(r)){
            return EdeviceDiagnosisTypeEnum.getXrayNamesByCodes(r, "、");
        }
        return "";
    }

    public String getR1() {
        if(!StringUtils.isEmpty(r)){
            return EdeviceDiagnosisTypeEnum.getInterventionalNamesByCodes(r, "、");
        }
        return "";
    }

    public String getR2() {
        if(!StringUtils.isEmpty(r)){
            return EdeviceDiagnosisTypeEnum.getNamesByCodes(r, "、");
        }
        return "";
    }

    public String getR3() {
        if(!StringUtils.isEmpty(r)){
            return EdeviceDiagnosisTypeEnum.getNuclearNamesByCodes(r, "、");
        }
        return "";
    }

    public String getR4() {
        if(!StringUtils.isEmpty(r)){
            return EdeviceDiagnosisTypeEnum.getRadiationNamesByCodes(r, "、");
        }
        return "";
    }
}
