package cn.smarthse.rho.modules.sys.model.home.vo;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * 首页可视化-关键因素画像与风险化解管理统计
 */
@Data
public class HomeData2Detail implements Serializable {

    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * （前端取值）画像情况
     */
    private String riskPortrait;
    /**
     * （前端取值）预警处理
     */
    private String warningHandling;
    /**
     * （前端取值）风险化解
     */
    private String riskResolution;

    /**
     * 风险类型
     */
    private Integer riskType;
    /**
     * 预警总数
     */
    private Integer warningTotalNum = 0;
    /**
     * 预警未化解数（待整改或已退回）
     */
    private Integer warningUnresolvedNum = 0;
    /**
     * 预警已化解数
     */
    private Integer warningResolvedNum = 0;
    /**
     * 风险总数
     */
    private Integer harmTotalNum = 0;
    /**
     * 风险未化解数（待整改或已退回）
     */
    private Integer harmUnresolvedNum = 0;
    /**
     * 风险已化解数
     */
    private Integer harmResolvedNum = 0;

    public String getRiskPortrait() {
        if ((warningUnresolvedNum + harmUnresolvedNum) > 0) {
            return "有风险";
        }
        return "无风险";
    }

    public String getWarningHandling() {
        return warningResolvedNum + "/" + warningTotalNum;
    }

    public String getRiskResolution() {
        return harmResolvedNum + "/" + harmTotalNum;
    }

}
