package cn.smarthse.rho.modules.sys.model.home.vo;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * 单位端：首页可视化-关键因素画像与风险化解管理
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/6/6 13:56
 */
@Data
public class HomeData2 implements Serializable {

    @Serial
    private static final long serialVersionUID = -1L;

    //---------------------------------------------------------预警统计----------------------------------------------------------

    /**
     * 首次预警
     */
    private Integer harmNumWarning1;
    /**
     * 黄色预警
     */
    private Integer harmNumWarning2;
    /**
     * 红色预警
     */
    private Integer harmNumWarning3;
    /**
     * 启动执法
     */
    private Integer harmNumWarning4;

    //-------------------------------------------------------------8项风险------------------------------------------------------

    /**
     * 许可校验
     */
    HomeData2Detail detail101;
    /**
     * 设备性能检测
     */
    HomeData2Detail detail102;
    /**
     * 场所检测
     */
    HomeData2Detail detail103;
    /**
     * 职业健康体检
     */
    HomeData2Detail detail104;
    /**
     * 个人剂量监测
     */
    HomeData2Detail detail105;
    /**
     * 放射工作人员培训
     */
    HomeData2Detail detail106;
    /**
     * 个人防护用品
     */
    HomeData2Detail detail108;
    /**
     * 安全装置和警示标识
     */
    HomeData2Detail detail109;

    //-------------------------------------------------------------6项异常------------------------------------------------------

    /**
     * 性能检测结果异常
     */
    HomeData2Detail detail102001;
    /**
     * 场所检测结果异常
     */
    HomeData2Detail detail103001;
    /**
     * 体检-疑似职业病
     */
    HomeData2Detail detail104004;
    /**
     * 体检-职业禁忌证
     */
    HomeData2Detail detail104005;
    /**
     * 体检-复查
     */
    HomeData2Detail detail104006;
    /**
     * 个人剂量-超剂量照射
     */
    HomeData2Detail detail105002;

}
