package cn.smarthse.rho.modules.sys.model.home.vo;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;

/**
 *
 * 单位端：首页可视化-基础信息
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/6/6 13:56
 */
@Data
public class HomeData1 implements Serializable {

    private static final long serialVersionUID = -1L;

    //@ApiModelProperty("医院Id")
    private Long id;
    //@ApiModelProperty("放射卫管理人员id")
    private Long raManagerId;

    //@ApiModelProperty("主要负责人")
    @Desensitization(type = DesensitizationType.NAME)
    private String mainLeaderName;

    //@ApiModelProperty("主要负责人联系电话")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String mainLeaderTel;

    //@ApiModelProperty("放射卫管理人员")
    @Desensitization(type = DesensitizationType.NAME)
    private String raManagerName;

    //@ApiModelProperty("放射卫管理人员联系电话")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String raManagerTel;

    //@ApiModelProperty("统一社会信用代码")
    private String creditCode;

    //@ApiModelProperty("院区名称")
    private String name;

    //@ApiModelProperty("是否是主院区（1-主院区；0-分院区）")
    private Integer isMain;

    //@ApiModelProperty("注册地址详情（浙江省杭州市上城区笕桥街道水墩新路88号）")
    private String fullAddress;

    //@ApiModelProperty("医疗机构类别码")
    private Integer type;

    //@ApiModelProperty("医疗机构类别")
    private String typeName;

    //@ApiModelProperty("医院等级（105）")
    private Integer unitLevel;

    //@ApiModelProperty("医院等级（105）")
    private String unitLevelName;

    //@ApiModelProperty("经营性质（106）")
    private Integer businessType;

    //@ApiModelProperty("经营性质（106）")
    private String businessTypeName;

    //@ApiModelProperty("本年度监督次数")
    private Integer superviseTimes;

    //@ApiModelProperty("本年度执法次数")
    private Integer enforcementTimes;

    //@ApiModelProperty("当年新增职业病人数")
    private Integer diseaseAddNum;

    //@ApiModelProperty("累计职业病人数")
    private Integer diseaseNum;

}
