package cn.smarthse.rho.modules.sys.model.g.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 安全装置自检列表的值对象
 */
@Data
@Accessors(chain = true)
public class GSafetyDeviceSelfCheckListVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 自检记录的唯一标识
     */
    private Long id;

    /**
     * 自检时间
     */
    private LocalDate checkTime;

    /**
     * 佐证材料ID
     */
    private Long certificateFile;

    /**
     * 佐证材料的文件信息
     */
    private SysFileVo certificateFileVo;

    /**
     * 承诺人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    /**
     * 承诺人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String phone;

    /**
     * 承诺书文件ID
     */
    private Long commitmentFile;

    /**
     * 承诺书文件信息
     */
    private SysFileVo commitmentFileVo;

    /**
     * 数据更新时间
     */
    private String dataUpdateTime;

    /**
     * 状态
     */
    private Integer status;
}
