package cn.smarthse.rho.modules.sys.model.g.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 个人防护用品自检列表视图对象
 * @author czq
 * @date 2025-05-06 13:57
 */
@Data
@Accessors(chain = true)
public class GEquipmentSelfCheckListVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 自检ID
     */
    private Long id;

    /**
     * 自检时间
     */
    private LocalDate checkTime;

    /**
     * 佐证材料ID
     */
    private Long certificateFile;

    /**
     * 佐证材料文件信息
     */
    private SysFileVo certificateFileVo;

    /**
     * 承诺人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    /**
     * 承诺人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String phone;

    /**
     * 承诺书文件ID
     */
    private Long commitmentFile;

    /**
     * 承诺书文件信息
     */
    private SysFileVo commitmentFileVo;

    /**
     * 数据更新时间
     */
    private String dataUpdateTime;

    /**
     * 状态
     */
    private Integer status;

}
