package cn.smarthse.rho.modules.sys.model.g.param;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 个人防护用品 新增或编辑自检信息参数
 * @author czq
 * @date 2025-05-06 13:41
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class GEquipmentSelfCheckEditParam {

    /**
     * 自检ID（用于编辑场景）
     */
    private Long id;

    /**
     * 医院ID（后端自动注入）
     */
    private Long cid;

    /**
     * 自检时间
     */
    @NotNull(message = "自检时间不能为空")
    private LocalDateTime checkTime;

    /**
     * 佐证材料文件ID
     */
    @NotNull(message = "佐证材料不能为空")
    private Long certificateFile;

    /**
     * 承诺人姓名
     */
    @NotBlank(message = "承诺人姓名不能为空")
    private String name;

    /**
     * 承诺人电话
     */
    @NotBlank(message = "承诺人电话不能为空")
    private String phone;

    /**
     * 承诺书文件ID
     */
    @NotNull(message = "承诺书不能为空")
    private Long commitmentFile;
}
