package cn.smarthse.rho.modules.sys.model.f.vo;

import cn.smarthse.rho.modules.sys.entity.f.FProject;
import cn.smarthse.rho.modules.sys.enums.f.FProjectDetailStatusEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectRaTypeEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectStatusEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 三同时管理列表VO
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FThreeTimesProjectVo extends FProject {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 三同时项目状态
     */
    private String statusStr;

    /**
     * 三同时项目性质
     */
    private String projectTypeStr;

    /**
     * 三同时项目类型
     */
    private String raTypeStr;

    /**
     * 设备 预、控评id
     */
    private Long detail1Id;

    /**
     * 设备 预、控评状态（1-进行中；2-已完成；3-合理缺项）
     */
    private Integer detail1Status;

    /**
     * 设备 预、控评状态中文
     */
    private String detail1StatusStr;

    /**
     * 设备 预、控评服务机构名称
     */
    private String tech1Name;

    /**
     * 场所 预、控评id
     */
    private Long detail2Id;

    /**
     * 场所 预、控评状态（1-进行中；2-已完成；3-合理缺项）
     */
    private Integer detail2Status;

    /**
     * 场所 预、控评状态中文
     */
    private String detail2StatusStr;

    /**
     * 场所 预、控评服务机构名称
     */
    private String tech2Name;

    public String getStatusStr() {
        return FProjectStatusEnum.getNameByValue(this.getStatus());
    }

    public String getProjectTypeStr() {
        return FProjectTypeEnum.getNameByValue(this.getProjectType());
    }

    public String getRaTypeStr() {
        return FProjectRaTypeEnum.getNameByValue(this.getRaType());
    }

    public String getDetail1StatusStr() {
        return FProjectDetailStatusEnum.getNameByValue(detail1Status);
    }

    public String getDetail2StatusStr() {
        return FProjectDetailStatusEnum.getNameByValue(detail2Status);
    }
}
