package cn.smarthse.rho.modules.sys.model.easyexcel.staff;

import cn.smarthse.modules.excel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@EqualsAndHashCode(callSuper = true)
@Data
public class StaffRelocationImportDto extends BaseImportDto implements Serializable {
    private static final long serialVersionUID = 4514255889752661062L;

    //excel行号
    private Integer excelRowIndex;

    //excel行号+1
    private Integer realityExcelRowIndex;

    @ExcelProperty("姓名")
    private String name;

    @ExcelProperty("身份证号码")
    private String idcard;

    @ExcelProperty("当前院区")
    private String beCompanyName;

    @ExcelProperty("目标院区名称")
    private String toCompanyName;

    @ExcelProperty("是否迁移")
    private String needRelocation;


    public Integer getRealityExcelRowIndex() {
        return this.excelRowIndex == null ? null : excelRowIndex + 1;
    }

}
