package cn.smarthse.rho.modules.sys.model.easyexcel.device;

import cn.smarthse.modules.excel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.util.StringUtils;

import java.io.Serializable;


/**
 * 非密封放射核素 导入对象
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SourceNonSealedImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 1848767587251701920L;

	//@ApiModelProperty(value = "excel行号")
	@ExcelIgnore
	private Integer excelRowIndex;

	//@ApiModelProperty(value = "excel行号+1")
	@ExcelIgnore
	private Integer realityExcelRowIndex;



	@ExcelProperty(value = "核素名称")
	private String name;

	@ExcelProperty(value = "核素生产厂家")
	private String factory;


	// ***********************

	/**
	 * 物理状态（1-固态；2-液态；3-气态）
	 */
	@ExcelProperty(value = "物理状态")
	private String physicalStateStr;
	@ExcelIgnore
	private Integer physicalState;

	@ExcelProperty(value = "出厂活度")
	private String factoryActivity;
	/**
	 * 出厂活度(底数，保留两位小数)
	 */
	@ExcelIgnore
	private Float data5;
	/**
	 * 出厂活度(指数)
	 */
	@ExcelIgnore
	private Integer data6;

	@ExcelProperty(value = "最大等效日操作量")
	private String maxDailyDose;
	/**
	 * 最大等效日操作量(前，保留两位小数)
	 */
	@ExcelIgnore
	private Float data1;
	/**
	 * 最大等效日操作量(后)
	 */
	@ExcelIgnore
	private Integer data2;



	@ExcelProperty(value = "最大等效年操作量")
	private String maxYearDose;
	/**
	 * 最大等效年操作量(前，保留两位小数)
	 */
	@ExcelIgnore
	private Float data3;
	/**
	 * 最大等效年操作量(后)
	 */
	@ExcelIgnore
	private Integer data4;

	@ExcelProperty(value = "负责人")
	private String personInCharge;


	public Integer getPhysicalState() {
		if (physicalStateStr == null){
			return null;
		}

		if (physicalStateStr.equals("固态")){
			physicalState = 1;
		} else if (physicalStateStr.equals("液态")){
			physicalState = 2;
		} else if (physicalStateStr.equals("气态")){
			physicalState = 3;
		}
		return physicalState;
	}



	public Float getData1() {
		if (!StringUtils.hasLength(maxDailyDose)
				|| !maxDailyDose.contains("×10^")){
			return null;
		}
		// 解析maxDailyDose，×10^前的字符转为data1
		data1 = Float.parseFloat(maxDailyDose.substring(0, maxDailyDose.indexOf("×10^")));
		return data1;
	}

	public Integer getData2() {
		if (!StringUtils.hasLength(maxDailyDose)
				|| !maxDailyDose.contains("×10^")){
			return null;
		}
		// 解析maxDailyDose，×10^后的字符转为data2
		data2 = Integer.parseInt(maxDailyDose.substring(maxDailyDose.indexOf("×10^") + 4));
		return data2;
	}

	public Float getData3() {
		if (!StringUtils.hasLength(maxYearDose)
				|| !maxYearDose.contains("×10^")){
			return null;
		}
		data3 = Float.parseFloat(maxYearDose.substring(0, maxYearDose.indexOf("×10^")));
		return data3;
	}

	public Integer getData4() {
		if (!StringUtils.hasLength(maxYearDose)
				|| !maxYearDose.contains("×10^")){
			return null;
		}
		data4 = Integer.parseInt(maxYearDose.substring(maxYearDose.indexOf("×10^") + 4));
		return data4;
	}

	public Float getData5() {
		if (!StringUtils.hasLength(factoryActivity)
				|| !factoryActivity.contains("×10^")){
			return null;
		}
		data5 = Float.parseFloat(factoryActivity.substring(0, factoryActivity.indexOf("×10^")));
		return data5;
	}

	public Integer getData6() {
		if (!StringUtils.hasLength(factoryActivity)
				|| !factoryActivity.contains("×10^")){
			return null;
		}
		data6 = Integer.parseInt(factoryActivity.substring(factoryActivity.indexOf("×10^") + 4));
		return data6;
	}


}
