package cn.smarthse.rho.modules.sys.model.easyexcel.device;

import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceRayCheckTypeEnum;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 射线装置 导入对象
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DeviceRayImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 466832649532939891L;

	//@ApiModelProperty(value = "excel行号")
	@ExcelIgnore
	private Integer excelRowIndex;

	//@ApiModelProperty(value = "excel行号+1")
	@ExcelIgnore
	private Integer realityExcelRowIndex;



	@ExcelProperty(value = "装置名称")
	private String name;

	@ExcelProperty(value = "设备编号")
	private String factoryNo;

	@ExcelProperty(value = "装置生产厂家")
	private String factory;

	/**
	 * 状态（1-正常；2-暂停使用；3-退役报废）
	 */
	@ExcelProperty(value = "设备状态")
	private String statusStr;
	@ExcelIgnore
	private Integer status;


	// ***********************

	@ExcelProperty(value = "型号")
	private String model;

	@ExcelProperty(value = "主要参数")
	private String parameters;


	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	@ExcelProperty(value = "设备类型")
	private String mobilityTypeStr;
	@ExcelIgnore
	private Integer mobilityType;
	/**
	 * 是否为床边机(0-否；1-是)（mobility_type为2时才有值）
	 */
	@ExcelIgnore
	private Integer isBedside;


	/**
	 * 射线装置类型id（sys_device_category）
	 */
	@ExcelProperty(index = 8)
	private String categoryStr1;
	@ExcelProperty(index = 9)
	private String categoryStr2;
	@ExcelProperty(index = 10)
	private String categoryStr3;
	@ExcelIgnore
	private Long category;


	/**
	 * 放射诊疗类别
	 * 由装置类型控制，根装置类别的二级分类保持一致
	 */
	@ExcelIgnore
	private String diagnosisTypeStr;
	@ExcelIgnore
	private String diagnosisType;


	/**
	 * 放射检查类型（EdeviceRayCheckTypeEnum）
	 * 由放射诊疗类别控制
	 */
	@ExcelProperty(value = "放射检查类型")
	private String checkTypeStr;
	@ExcelIgnore
	private Integer checkType;


	@ExcelProperty(value = "球管个数")
	private String bulbNum;

	@ExcelProperty(value = "出厂日期")
	// @DateTimeFormat(value = "yyyy-MM-dd")
	private String productionDate;

	@ExcelProperty(value = "安装单位")
	private String installationUnit;

	@ExcelProperty(value = "负责人")
	private String personInCharge;


	public Integer getStatus() {
		if (statusStr == null){
			return null;
		}
		if (statusStr.equals("正常")){
			status = 1;
		} else if (statusStr.equals("暂停使用")){
			status = 2;
		} else if (statusStr.equals("退役报废")){
			status = 3;
		}
		return status;
	}



	public Integer getMobilityType() {
		if (mobilityTypeStr == null){
			return null;
		}

		if (mobilityTypeStr.equals("固定设备")){
			mobilityType = 1;
		}
		if (mobilityTypeStr.equals("移动设备：床边机") || mobilityTypeStr.equals("移动设备：非床边机")){
			mobilityType = 2;
		}
		if (mobilityTypeStr.equals("车载设备")){
			mobilityType = 3;
		}
		return mobilityType;
	}

	public Integer getIsBedside() {
		if (mobilityTypeStr == null){
			return null;
		}
		if (mobilityTypeStr.equals("移动设备：床边机")){
			isBedside = 1;
		}
		if (mobilityTypeStr.equals("移动设备：非床边机")){
			isBedside = 0;
		}
		return isBedside;
	}

	public Integer getCheckType() {
		return EdeviceRayCheckTypeEnum.getCodeByName(checkTypeStr);
	}

	// public String getDiagnosisType() {
	// 	return "11";
	// }
}
