package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

@EqualsAndHashCode(callSuper = true)
@Data
public class TrainingCertImportDto extends BaseImportDto implements Serializable {

    @Serial
    private static final long serialVersionUID = 7724801396893204882L;

    @ExcelProperty(value = "姓名")
    private String staffName;

    @ExcelProperty(value = "身份证号")
    private String idCard;

    @ExcelProperty(value = "单位名称")
    private String companyName;

    @ExcelProperty(value = "证书编号")
    private String certNo;

    @ExcelProperty(value = "考试结果")
    private String examResultStr;
    private Integer examResult;

    @ExcelProperty(value = "取证日期")
    private LocalDate issuanceDate;
    private LocalDate certValidDate;

    @ExcelProperty(value = "培训类型")
    private String trainingTypeStr;
    private String trainingType;

    public String getTrainingType() {
        if (!StringUtils.isEmpty(trainingTypeStr)) {
            return trainingTypeStr.equals("岗中") ? "0" : (trainingTypeStr.equals("岗前") ? "1" : null);
        }
        return null;
    }

    public LocalDate getCertValidDate() {
        if (issuanceDate != null) {
            return issuanceDate.plusYears(2);
        }
        return null;
    }
}