package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.excel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@EqualsAndHashCode(callSuper = true)
@Data
public class StaffImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 7724801396893204882L;

	//@ApiModelProperty(value = "excel行号")
	private Integer excelRowIndex;


	//@ApiModelProperty(value = "excel行号+1")
	private Integer realityExcelRowIndex;

	//@ApiModelProperty(value = "姓名")
	@ExcelProperty("姓名")
	private String name;

	//@ApiModelProperty(value = "手机号")
	@ExcelProperty("手机号码")
	private String phone;

	//@ApiModelProperty(value = "身份证")
	@ExcelProperty("身份证号")
	private String idcard;

	//@ApiModelProperty(value = "性别")
	@ExcelProperty("性别")
	private String sex;

	//@ApiModelProperty(value = "年龄")
	@ExcelProperty("年龄")
	private String age;

	//@ApiModelProperty(value = "职业照射种类及代码")
	@ExcelProperty("职业照射种类及代码")
	private String raType;

	//下面是公司相关数据
	//@ApiModelProperty(value = "院区")
	@ExcelProperty("所在院区")
	private String companyName;

	//@ApiModelProperty(value = "工号")
	@ExcelProperty("工号")
	private String workNo;

	public Integer getRealityExcelRowIndex() {
		return this.excelRowIndex == null ? null : excelRowIndex + 1;
	}

	public void desensitizeNameTotal(){
		this.genName();
		this.genIdcard();
		this.genPhone();
	}

	public void genName() {
		this.name = DesensitizationUtils.desensitized(name, DesensitizationType.NAME);
	}
	public void genIdcard() {
		this.idcard = DesensitizationUtils.desensitized(idcard, DesensitizationType.ID_CARD);
	}
	public void genPhone() {
		this.phone = DesensitizationUtils.desensitized(phone, DesensitizationType.MOBILE_PHONE);
	}

}