package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.converter.StringConverter;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

@EqualsAndHashCode(callSuper = true)
@Data
public class RiskBatchChooseImportDto extends BaseImportDto implements Serializable {

    @Serial
    private static final long serialVersionUID = 7724801396893204882L;

    @ExcelProperty(value = "风险编号", converter = StringConverter.class)
    private Long sourceId;

    @ExcelProperty(value = "整改编号", converter = StringConverter.class)
    private Long acceptanceRecordId;

    @ExcelProperty(value = "风险名称")
    private String riskName;

    @ExcelProperty(value = "所在场所")
    private String locationName;

    @ExcelProperty(value = "设备数量")
    private Integer deviceNum;

    @ExcelProperty(value = "正常使用设备数量")
    private Integer locationDeviceNum;

    @ExcelProperty(value = "是否使用非密封放射性核素")
    private String isUsedNonSealedSpeciesStr;
    private Boolean isUsedNonSealedSpecies;

    private Integer postStatus;
    @ExcelProperty(value = "岗位状态")
    private String postStatusStr;

    private Integer healthRiskPostType;
    @ExcelProperty(value = "体检风险类型")
    private String healthRiskPostTypeStr;

    @ExcelProperty(value = "证书有效期")
    private LocalDate certValidDate;

    @ExcelProperty(value = "最近一次检测时间")
    private LocalDate lastCheckDate;

    @ExcelProperty(value = "最近一次体检时间")
    private LocalDate lastHealthCheckDate;

    private Integer healthLastType;
    @ExcelProperty(value = "最近一次体检类型")
    private String healthLastTypeStr;

    @ExcelProperty(value = "最近一次个人剂量监测时间")
    private LocalDate lastDoseMonitorDate;

    @ExcelProperty(value = "整改期限")
    private LocalDate requireFinishTime;

    /**
     * 细分业务id（如体检，subBusinessId为具体到人员基础信息id[staffBaseInfoId]，此时businessId为对应的体检id）
     */
    private Long subBusinessId;
    /**
     * 风险类型 （RiskTypeEnum）
     */
    private Integer riskType;

    public Integer getPostStatus() {
        if (StringUtils.isNotEmpty(postStatusStr)) {
            return PostStatusEnum.getValue(postStatusStr);
        }
        return postStatus;
    }

    public Integer getHealthRiskPostType() {
        if (StringUtils.isNotEmpty(healthRiskPostTypeStr)) {
            return RiskPostStatusEnum.getValue(healthRiskPostTypeStr);
        }
        return healthRiskPostType;
    }

    public Boolean getIsUsedNonSealedSpecies() {
        if (StringUtils.isNotEmpty(isUsedNonSealedSpeciesStr)) {
            return "是".equals(isUsedNonSealedSpeciesStr);
        }
        return isUsedNonSealedSpecies;
    }
}