package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.rho.modules.sys.converter.StringConverter;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

// 批量选择导出-体检
@Data
public class RiskBatchChooseExportDto3 implements Serializable {

    @Serial
    private static final long serialVersionUID = 7724801396893204882L;

    @ExcelProperty(value = "风险编号", converter = StringConverter.class)
    private Long sourceId;

    @ExcelProperty(value = "整改编号", converter = StringConverter.class)
    private Long acceptanceRecordId;

    @ExcelProperty(value = "风险名称")
    private String riskName;

    @ExcelIgnore
    private Integer postStatus;
    @ExcelProperty(value = "岗位状态")
    private String postStatusStr;

    @ExcelIgnore
    private Integer healthRiskPostType;
    @ExcelProperty(value = "体检风险类型")
    private String healthRiskPostTypeStr;

    @ExcelProperty(value = "最近一次体检时间")
    private LocalDate lastHealthCheckDate;

    @ExcelProperty(value = "最近一次体检类型")
    private String healthLastTypeStr;

    @ExcelProperty(value = "整改期限")
    private LocalDate requireFinishTime;

    //细分业务id（如体检，subBusinessId为具体到人员的id，此时businessId为对应的体检id）
    @ExcelIgnore
    private Long subBusinessId;

    //风险类型 （RiskTypeEnum）
    @ExcelIgnore
    private Integer riskType;

}