package cn.smarthse.rho.modules.sys.model.e.vo;

import cn.smarthse.rho.core.framework.utils.StringUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 机房设备统计
 */
@Data
public class LocationDeviceStatisticVo implements Serializable {

    private static final long serialVersionUID = -5616595192595152321L;

    /**
     * 机房ID
     */
    private Long locationId;

    /**
     * 关联设备数（正常使用）
     */
    private Integer locationDeviceNum = 0;
    /**
     * 射线装置和含密封源装置（正常使用）
     */
    private Integer locationDeviceNum1 = 0;
    /**
     * 非密封放射性核素（正常使用）
     */
    private Integer locationDeviceNum2 = 0;

    /**
     * 装置（所有状态）
     */
    private Integer locationDeviceNum3 = 0;

    /**
     * 装置、核素ids集合
     */
    private List<Long> deviceIds;
    /**
     * 装置ids
     */
    private String deviceIds1;
    /**
     * 核素ids
     */
    private String deviceIds2;

    public Integer getLocationDeviceNum() {
        return locationDeviceNum1 + locationDeviceNum2;
    }

    public List<Long> getDeviceIds() {
        List<Long> deviceIds = new ArrayList<>();
        if (StringUtils.isNotEmpty(deviceIds1)) {
            deviceIds.addAll(Arrays.stream(deviceIds1.split(",")).map(Long::parseLong).toList());
        }
        if (StringUtils.isNotEmpty(deviceIds2)) {
            deviceIds.addAll(Arrays.stream(deviceIds2.split(",")).map(Long::parseLong).toList());
        }
        return deviceIds;
    }
}
